  class FiltruBase {


    constructor(field) {
      this.field = field;
      this.php   = {
        refresh_info_filtre: '',
        alte_operatiuni_listare :'',
        get_info: '',
        get_info_dialog:'',
        get_info_item_dialog_after:'',
        save_after:'',
        alte_functii:''
      };
      this.vue_list = {
        template_filtre: '',
        filtre_array: '',
        after_get_info: ''
      }
      this.init();
    }
    
    init(){
        //override this
    }

    static factoryCreateNew(field) {
        var ret = null;
        if( field.Type == "text-simplu"     ) ret = new Filtru_TextSimplu   (field);
        if( field.Type == "numeric"         ) ret = new Filtru_Numeric      (field);
        if( field.Type == "numeric-range"   ) ret = new Filtru_NumericRange (field);
        if( field.Type == "select-enum"     ) ret = new Filtru_SelectEnum   (field);
        if( field.Type == "select-db"       ) ret = new Filtru_SelectDb     (field);
        return ret;
    }
  }

  class Filtru_TextSimplu extends FiltruBase {
    constructor(field) {
      super(field);
    }

    init(){
        const DbColumn  = this.field.DbColumn;
        const Label     = this.field.Label;
        //
        this.php.refresh_info_filtre  = `$sql->addIfNeeded($filters['${DbColumn}'], '', " AND t1.${DbColumn} LIKE '%%%s%%' ");`;
        this.vue_list.template_filtre = ` 
        <el-col :span='4'>
            <el-form-item label='${Label}' >
                <el-input v-model='Filters.${DbColumn}' />
            </el-form-item>
        </el-col>`;
    }
  }

  class Filtru_Numeric extends FiltruBase {
    constructor(field) {
      super(field);
    }
  
    init() {
      const DbColumn    = this.field.DbColumn;
      const Label       = this.field.Label;
      const Precizie    = this.field.Precizie;
  
      this.php.refresh_info_filtre = `$sql->addIfNeeded($filters['${DbColumn}'], '', " AND t1.${DbColumn} = '%s' ");`;
      this.vue_list.template_filtre = `
        <el-col :span='4'>
          <el-form-item label='${Label}' >
            <el-input-number v-model='Filters.${DbColumn}' :precision='${Precizie}' :max='999999'/>
          </el-form-item>
        </el-col>`;
    }
  }

  class Filtru_NumericRange extends FiltruBase {
    constructor(field) {
      super(field);
    }
  
    init() {
      const DbColumn    = this.field.DbColumn;
      const Label       = this.field.Label;
      const Precizie    = this.field.Precizie;
  
      this.php.refresh_info_filtre = `
        $sql->addIfNeeded($filters['${DbColumn}_Min'], '', ' AND t1.${DbColumn} >= %s');
        $sql->addIfNeeded($filters['${DbColumn}_Max'], '', ' AND t1.${DbColumn} <= %s');
      `;
  
      this.vue_list.template_filtre = `
        <el-col :span='8'>
          <el-form-item label='${Label} Min'>
            <el-input-number v-model='Filters.${DbColumn}_Min' :precision='${Precizie}' :max='999999' />
          </el-form-item>
        </el-col>
        <el-col :span='8'>
          <el-form-item label='${Label} Max'>
            <el-input-number v-model='Filters.${DbColumn}_Max' :precision='${Precizie}' :max='999999' />
          </el-form-item>
        </el-col>
      `;
    }
  }

  class Filtru_SelectEnum extends FiltruBase {
    constructor(field) {
      super(field);
    }
  
    init() {
        const DbColumn = this.field.DbColumn;
        const Label     = this.field.Label;
        const Valori    = this.field.Campuri.Valori;
        const Labels    = this.field.Campuri.Labels;

        this.php.refresh_info_filtre = `
            $sql->addIfNeeded($filters['${DbColumn}'], '', " AND t1.${DbColumn} = '%s' ");
        `;

        this.vue_list.template_filtre = `
            <el-col :span='4'>
                <el-form-item label='${Label}'>
                    <el-select v-model='Filters.${DbColumn}'>`;
        for(var i = 0; i < Valori.length; i++){
            this.vue_list.template_filtre += `<el-option label='${Labels[i]}' value='${Valori[i]}' />`;
        }

        this.vue_list.template_filtre += `
                    </el-select>
                </el-form-item>
            </el-col>
        `;
    }
  }

  class Filtru_SelectDb extends FiltruBase {
    constructor(field) {
      super(field);
    }
  
    init() {
        const DbColumn                      = this.field.DbColumn;
        const Label                         = this.field.Label;
        const Tabel2                        = this.field.Tabel2;
        const ColoanaId                     = this.field.ColoanaId;
        const ColoanaLabel                  = this.field.ColoanaLabel;
        const ValoareDeIgnorat              = this.field.ValoareDeIgnorat;
        const LabelValoareDeIgnorat         = this.field.LabelValoareDeIgnorat;
        const BifamImplicitPrimulElement    = this.field.BifamImplicitPrimulElement;

        this.php.refresh_info_filtre = `
            $sql->addIfNeeded($filters['${DbColumn}'], '${ValoareDeIgnorat}', " AND t1.${DbColumn} = '%s' ");
        `;
        this.php.get_info = `$ret->Info->${Tabel2} = $this->db->table("${Tabel2}")->select("${ColoanaId}, ${ColoanaLabel}")->get()->getResult();`;

        this.vue_list.template_filtre = `
            <el-col :span='4'>
                <el-form-item label='${Label}'>
                    <el-select v-model='Filters.${DbColumn}'>`;
        
        if(LabelValoareDeIgnorat != '') {
            this.vue_list.template_filtre += `<el-option label='${LabelValoareDeIgnorat}' value='${ValoareDeIgnorat}' />`;
        }
        
        this.vue_list.template_filtre += `<el-option v-for='(item, index) in Filtre.${DbColumn}' :label='item.${ColoanaLabel}' :value='item.${ColoanaId}' />`;
        
        this.vue_list.template_filtre += `
                    </el-select>
                </el-form-item>
            </el-col>
        `;

        this.vue_list.filtre_array = ` ${DbColumn}='', `;

        if( BifamImplicitPrimulElement ){
            this.vue_list.after_get_info = ``;
        }
    }
  }