
import axios from 'axios';
import filtreHelper from '@/backend/generator/filtre';
import listareHelper from '@/backend/generator/listare';


export default {
    async genereaza_controller_php(nume_controller, nume_tabela, items_listare, fields_filtrare, items_editare) {
        var listare     = ( await axios.get("listare.json"    ) ).data;
        var filtrare    = ( await axios.get("filtrare.json"   ) ).data;
        var editare     = ( await axios.get("editare.json"    ) ).data;
        var template    = ( await axios.get("templates/controller.php") ).data;

        //
        template = template.replace(/{{nume_controller}}/g, nume_controller);
        template = template.replace(/{{nume_tabela}}/g, nume_tabela);

        var _f = new filtreHelper.FiltruBase();
        var replaces = {};
        Object.keys(_f.php).forEach( key => {
            replaces[key] = "";
        });

        //pentru filtrare
        fields_filtrare.forEach( field => {
            var _f = filtreHelper.FiltruBase.factoryCreateNew(field);
            if( _f != null ){
                Object.keys(_f.php).forEach( key => {
                   replaces[key] += _f.php[key]; 
                });
            }else{
                console.error("Nu am gasit tipul de filtru " + field.Type);
            }
        });

        Object.keys(replaces).forEach( key => {
            template = template.replaceAll("{{" + key + "}}", replaces[key]  ); 
        });
        
        //
        return template;
    },

    async genereaza_fisier_lista_vue(nume_controller, nume_tabela, fields_listare, fields_filtrare, items_editare) {
        var listare     = ( await axios.get("listare.json"    ) ).data;
        var filtrare    = ( await axios.get("filtrare.json"   ) ).data;
        var editare     = ( await axios.get("editare.json"    ) ).data;
        var template    = ( await axios.get("templates/vue_list.txt") ).data;

        //
        template = template.replace(/{{nume_controller}}/g, nume_controller);
        template = template.replace(/{{nume_tabela}}/g, nume_tabela);

        //pentru listare
        var _f = new listareHelper.ListareBase();
        var replaces = {};
        Object.keys(_f.vue_list).forEach( key => {
            replaces[key] = "";
        });
        fields_listare.forEach( field => {
            var _f = listareHelper.ListareBase.factoryCreateNew(field);
            if( _f != null ){
                Object.keys(_f.vue_list).forEach( key => {
                   replaces[key] += _f.vue_list[key]; 
                });
            }else{
                console.error("Nu am gasit tipul de listare " + field.Type);
            }
        });
        Object.keys(replaces).forEach( key => {
            template = template.replaceAll("{{" + key + "}}", replaces[key]  ); 
        });

        //pentru filtrare
        var _f = new filtreHelper.FiltruBase();
        var replaces = {};
        Object.keys(_f.vue_list).forEach( key => {
            replaces[key] = "";
        });
        fields_filtrare.forEach( field => {
            var _f = filtreHelper.FiltruBase.factoryCreateNew(field);
            if( _f != null ){
                Object.keys(_f.vue_list).forEach( key => {
                   replaces[key] += _f.vue_list[key]; 
                });
            }else{
                console.error("Nu am gasit tipul de filtru " + field.Type);
            }
        });
        Object.keys(replaces).forEach( key => {
            template = template.replaceAll("{{" + key + "}}", replaces[key]  ); 
        });
        
        return template;
    },

    async genereaza_fisier_dialog_vue(nume_controller, nume_tabela, items_listare, fields_filtrare, fields_editare) {
        var listare     = ( await axios.get("listare.json"    ) ).data;
        var filtrare    = ( await axios.get("filtrare.json"   ) ).data;
        var editare     = ( await axios.get("editare.json"    ) ).data;
        var template    = ( await axios.get("templates/vue_dialog.txt") ).data;

        //
        template = template.replace(/{{nume_controller}}/g, nume_controller);
        template = template.replace(/{{nume_tabela}}/g, nume_tabela);

        var _f = new filtreHelper.EditorBase();
        var replaces = {};
        Object.keys(_f.vue_dialog).forEach( key => {
            replaces[key] = "";
        });

        //pentru editare
        fields_editare.forEach( field => {
            var _f = filtreHelper.EditorBase.factoryCreateNew(field);
            if( _f != null ){
                Object.keys(_f.vue_dialog).forEach( key => {
                   replaces[key] += _f.vue_dialog[key]; 
                });
            }else{
                console.error("Nu am gasit tipul de filtru " + field.Type);
            }
        });

        Object.keys(replaces).forEach( key => {
            template = template.replaceAll("{{" + key + "}}", replaces[key]  ); 
        });
        
        return template;
    },
 
};
