<?php

namespace App\Controllers;

use ApiResponse;
use App\Controllers\BaseAdminController;
use CodeIgniter\Database\BaseConnection;
use PaginationInfo;
use stdClass;
use TableSql;

class {{nume_controller}} extends BaseAdminController
{

    public function refresh_info()
    {
        $ret = $this->verify_login();

        if (!$ret->NotLogged) {
            $filters    = $this->request->getPost("Filters");
            $order_by   = $this->request->getPost("OrderBy");
            $pg_info    = new PaginationInfo($this->request->getPost("PaginationInfo"));
            //
            $sql        = new TableSql("SELECT t1.* FROM {{nume_tabela}} t1 WHERE 'a'='a'  ");
            {{refresh_info_filtre}}
            $sql->addLimitFromPagination($pg_info);
            //
            $result = $sql->getResult();
            $rows = $result->Rows;
            foreach($rows as $row){
                {{alte_operatiuni_listare}}
            }
            //
            $pg_info->RowCount = $result->FullRowsCount;
            $ret->Results = $rows;
            $ret->PaginationInfo = $pg_info;
        }

        return $this->response->setJSON($ret);
    }

    public function get_info()
    {
        $ret = $this->verify_login();
        if (!$ret->NotLogged) {
            $ret->Info = new stdClass();
            {{get_info}}
        }
        return $this->response->setJSON($ret);
    }

    public function get_info_dialog()
    {
        $ret = $this->verify_login();

        if (!$ret->NotLogged) {
            $ret->Info = new stdClass();
            {{get_info_dialog}}
        }

        return $this->response->setJSON($ret);
    }

    public function get_info_item_dialog()
    {
        $ret = $this->verify_login();

        if (!$ret->NotLogged) {
            $id = $this->request->getPost("id");
            $ret->Item = $this->db->table("{{nume_tabela}}")->where("id", $id)->get()->getFirstRow();
            {{get_info_item_dialog_after}}
        }

        return $this->response->setJSON($ret);
    }

    public function save()
    {
        $ret = $this->verify_login();

        if (!$ret->NotLogged) {
            $mode = $this->request->getPost("mode");
            $item = $this->request->getPost("object");

            $id = -1;

            {{save_before}}

            if ($mode == "add") {
                if (array_key_exists('Id', $item)) unset($item['Id']);
                $this->db->table("{{nume_tabela}}")->insert($item); // Schimbați "clienti" cu "categorii"
                $id = $this->db->insertID();
            } else {
                $id = $item['Id'];
                unset($item['Id']);
                $this->db->table("{{nume_tabela}}")->where("Id", $id)->update($item); // Schimbați "clienti" cu "categorii"
            }
            {{save_after}}
        }

        return $this->response->setJSON($ret);
    }

    public function delete_item()
    {
        $ret = $this->verify_login();

        if (!$ret->NotLogged) {
            $id = $this->request->getPost("id");
            $this->db->table("{{nume_tabela}}")->where("id", $id)->set("Sters", "1")->update(); // Schimbați "clienti" cu "categorii"
        }

        return $this->response->setJSON($ret);
    }

    public function undelete_item()
    {
        $ret = $this->verify_login();

        if (!$ret->NotLogged) {
            $id = $this->request->getPost("id");
            $this->db->table("{{nume_tabela}}")->where("id", $id)->set("Sters", "0")->update(); // Schimbați "clienti" cu "categorii"
        }

        return $this->response->setJSON($ret);
    }

   {{alte_functii}}
}