<?php

namespace App\Controllers;

use CodeIgniter\Controller;
use CodeIgniter\Database\BaseConnection;
use CodeIgniter\HTTP\CLIRequest;
use CodeIgniter\HTTP\IncomingRequest;
use CodeIgniter\HTTP\RequestInterface;
use CodeIgniter\HTTP\Response;
use CodeIgniter\HTTP\ResponseInterface;
use Config\Services;
use Psr\Log\LoggerInterface;
use stdClass;
use chillerlan\QRCode\QRCode;
use chillerlan\QRCode\QROptions;
use DateInterval;
use DatePeriod;
use DateTime;

/**
 * Class BaseController
 *
 * BaseController provides a convenient place for loading components
 * and performing functions that are needed by all your controllers.
 * Extend this class in any new controllers:
 *     class Home extends BaseController
 *
 * For security be sure to declare any new methods as protected or private.
 */
abstract class BaseAdminController extends Controller
{
    /**
     * Instance of the main Request object.
     *
     * @var CLIRequest|IncomingRequest
     */
    protected $request;

    /**
     * An array of helpers to be loaded automatically upon
     * class instantiation. These helpers will be available
     * to all other controllers that extend BaseController.
     *
     * @var array
     */
    protected $helpers = ["ApiResponse","table_sql", "numbers", "credite"];

    /**
     * Be sure to declare properties for any property fetch you initialized.
     * The creation of dynamic property is deprecated in PHP 8.2.
     */
    // protected $session;

    protected BaseConnection $db;
    /**
     * Constructor.
     */
    public function initController(RequestInterface $request, ResponseInterface $response, LoggerInterface $logger)
    {
        
        // Do Not Edit This Line
        parent::initController($request, $response, $logger);

        // Preload any models, libraries, etc, here.
        $this->db = \Config\Database::connect();
        $this->db->query("SET NAMES 'utf8mb4'");
        // E.g.: $this->session = \Config\Services::session();
        header('Access-Control-Allow-Origin: *');
        header("Access-Control-Allow-Methods: POST, GET, PUT, OPTIONS");
        header("Access-Control-Allow-Credentials: true");
        header("Access-Control-Allow-Headers: *");
        
        if($this->request->is("OPTIONS")){
            $response = service('response');
            $response->setStatusCode(Response::HTTP_OK);
            $response->send();
            die();
        }
    }

    public function verify_login() {
        $ret = new stdClass();
        $ret->NotLogged = $this->get_logged_user() == null;
        $ret->Error       = false;
        $ret->MesajEroare = "";
        return $ret;
    }

    public function get_logged_user() {
        $token          = $this->request->getHeaderLine("token");
        $client         =  $this->db->query("SELECT * FROM utilizatori WHERE Token=?", [$token])->getRow();
        return $client;
    }

    public function get_date_between($data1, $data2) {
        $begin      = new DateTime( $data1 );
        $end        = new DateTime( $data2 );
        $end        = $end->modify( '+1 day' ); 

        $interval   = new DateInterval('P1D');
        $daterange  = new DatePeriod($begin, $interval ,$end);

        $ret        = [];
        foreach($daterange as $date){
            $ret[] = $date->format("Y-m-d");
        }
        return $ret;
    }


}
